# Quantum Cube Model – LaTeX Package

Visualize quantum states and gate operations using cube diagrams in LaTeX.

## Overview

The `quantumcubemodel` package provides simple LaTeX commands for creating intuitive and scalable cube-based diagrams to represent quantum states of 1, 2, or 3 qubits. Inspired by Prof. B. Just’s framework, it’s especially useful for teaching, presentations, and educational material in quantum computing.

## Features

- Cube diagrams for 1, 2, or 3-qubit quantum states
- Representation of complex amplitudes and phases
- Visual transitions for quantum gates:
  - Hadamard
  - Pauli-X / Pauli-Z
  - CNOT
  - Toffoli
- Wireframe views for custom visualization
- Scalable diagrams using a global scale command

## License

MIT License
© 2025 Cedric Schacht

## Author

Cedric Schacht

cedric.schacht@mni.thm.de

https://github.com/CedricSchacht/quantumcubemodel