# Hybrid LaTeX - adding active Python code to LaTeX

## Overview

This is a collection of Python and Bash shell scripts that allows LaTeX documents to contain active Python code. The active code blocks are processed ahead of LaTeX and their results are accessible within the same LaTeX document. Thus a calculation that might otherwise be done using in two documents, one using Python to do the maths, and a separate LaTeX document to record the results can be consolidated into a single source.

There are other collections that achieve the same result, see [PyhtonTeX][1] and [SageTeX][2] .

The main differences between this package and PyhtonTeX and SageTeX are:

  * The tools are written in Python and Bash rather than LaTeX, thus allowing easy extension to other languages,
  * The results of the active code blocks are saved to a single file that can be easily shared with colleagues, journals or included in other LaTeX documents.

This version of the package is specific to embedded Python code. Extensions for Mathematica, Maple, Matlab and Cadabra can be found on the [github repository][5].

## Installation

There are a handful of files to install (by hand) for each language. These include Bash shell scripts, Python scripts and LaTeX style files. Each file can be copied to wherever their respective program expects to find them. For example, the Bash and Python scripts could be sudo copied to `/usr/local/bin` (for access by all users) or to `~/bin` (for your personal access). The LaTeX style files can be copied to wherever they will be visible to LaTeX (see [this discussion][3] on tex.stackexchange for useful suggestions). If you place the files in non-standard locations you may need to adjust your `PATH` and `TEXINPUT` environment variables accordingly. If all else fails, you can copy all of the Bash, Python and LaTeX files into the same directory as your LaTeX document (though this is a very bad solution).

More details on the installation can be found in the main documentation, `doc/hybrid.pdf`.

## Documentation

The main documentation can be found in `doc/hybrid.pdf`. See also the examples in `examples/`.

## Version

v0.1 (2018/08/22)

  * Initial relase.

## Author

>Leo Brewin,
>School of Mathematics,
>Monash University,
>Leo.Brewin@monash.edu

## License

All files in this collection are distributed under the [MIT][4] license. See the file LICENSE.txt for the full details.

  [1]: https://github.com/gpoore/pythontex
  [2]: https://github.com/sagemath/sagetex
  [3]: https://tex.stackexchange.com/questions/1137/where-do-i-place-my-own-sty-or-cls-files-to-make-them-available-to-all-my-te
  [4]: https://opensource.org/licenses/MIT
  [5]: https://github.com/leo-brewin/hybrid-latex
