{$IFDEF WINDOWS}
{$N-,V-,W-,G+}
{$ELSE}
{$E-,N-,V-}
{$ENDIF}

Unit bibutil;

Interface

uses
{$IFDEF WINDOWS}
  WinDos, Wobjects, wbibdisp, WinTypes, WinProcs, Strings, streams,
  wHugeMem, wbibbin, rc_id, Win31,
{$ELSE}
  bibwindo, Dos, objects, bibCrt, BibMouse, bibdisp, openfile,
{$ENDIF}
  bibstrg, bibstrm, rc_strng, bibfile, bibvars, bibtext, bib8bit,
  lfnunit;

const
  ChoosePgUp=1254; ChoosePgDn=1255; ChooseFirst=1256; ChooseLast=1257;

type
  TagActionType = (TagSet,TagClear,TagToggle);
  PPstring = ^PString;

  { Can't be placed in bibvars.pas because of unit interdependencies }
  
{$IFNDEF WINDOWS}
var
  CutPasteBuffer: PAuxStream; { Cut/Paste ReadBig buffer }
  StrAbbrevsList: char;       { Placeholder for a Windows variable }

procedure Restore_Mode;
procedure Set_BibDB_Mode;
{$ENDIF}
procedure AllocStrings(make: boolean; P1,P2,P3,P4: PPstring);
function  StringRC(id: integer; S: string): string;
procedure TeXWordGet(VAR Dest: string; var Sin; Slen: Word; var Ind: Word);
function  Scopy(Var S: BigTypePtr; Beg,Num: LongInt) : string;
function  ScopyNS(Var S: BigTypePtr; Beg,Num: LongInt) : string;
procedure Sdelete(Var S: BigTypePtr; Var Slen: word; Index,Num: longint);
procedure Sinsert(Var S: BigTypePtr; Var Slen: word; S_in: string;
                  Index: longint; MaxBig: Word);
procedure Cinsert(ch: Char; Var S: BigTypePtr; Var Slen: word;
                  Index: longint; MaxBig: Word);
function  PlaceCompare(place1,place2: longint): shortint;
procedure MaxMemAvail;
function  Imin(a1,a2: longint): longint;
function  Imax(a1,a2: longint): longint;
procedure Tag(realnum: longint; action: TagActionType; var Tags: TagType);
function  IsTagged(realnum: longint; var Tags: TagType): boolean;
procedure InsertNewTag(realnum: longint; var Tags: TagType);
procedure DeleteOldTag(realnum: longint; var Tags: TagType);
function  ContainsTags(Pattern: PatRecPtr): boolean;
procedure EraseTags(var Tags: TagType);
procedure ResetBibFile(var f: text; name: string);
procedure NewEntry(var entry: EntryRecPtr);
{procedure DisposeEntry(var entry: EntryRecPtr);}
function  EnoughMem(needed: longint): KeepModeType;
procedure PushBufferStack(var S; len: word; KeepMode: KeepModeType;
                          StackPos: byte);
procedure RecallBufferStack(var S; StackPos: byte);
procedure RecallPartBufStack(var S; len: Word; StackPos: byte);
procedure DiscardBufferStack;
procedure PopBufferStack(var S);
function  StoreEntry(F: PStream; Entry: EntryRecPtr): boolean;
function  LoadEntry (F: PStream; Entry: EntryRecPtr): boolean;
procedure ZeroSortMode(var M: ConfigSortType; Pattern: PatRecPtr);
procedure ZeroEntry(Entry: EntryRecPtr);
procedure ResetBib(Entry: EntryRecPtr);
{$IFNDEF WINDOWS}
procedure FatalError(S: String);
procedure FatalErrorRC(id: word; S: string);
procedure ContextHelp(Context: string);
procedure Open_Files(S: string);
{$ENDIF}
function  FindBigFree(Entry: EntryRecPtr; reserve: boolean): Byte;
function  OkField(var S1; slen: word; Verb: byte;
                  ErrorBraces,ErrorMacros: string;
                  var BareQuote: boolean): boolean;
procedure Capitalize(S: BigTypePtr; Var Slen: Word; Start,Finish: Word;
                     author: boolean);
function  FindInFieldList(S: string): integer;
function  FindInETypeList(S: string): integer;
procedure ShowPathList(PathList: PathListPtr);
procedure ReadSortRec(F: PStream; var Srec: SortRecType);
procedure FindSortRec(var Srec: SortRecType; Num: longint; var ok: boolean);
function  MakeUseOfIndex(Pattern: PatRecPtr): boolean;
{$IFNDEF WINDOWS}
procedure LoadStringAbbrevs(var T: char; Entry: EntryRecPtr);   { Placeholder for a Windows procedure }
{$ENDIF}
procedure StripBraces(var S: string; var BrDepth: integer;
                      var ExtraBrace,Math: boolean);
procedure ProtectMixedCase(S: BigTypePtr; var SLen: word; MaxBig: word;
                           ProtCap: boolean);
procedure WinYield;
function  ActivePattern(Pattern: PatRecPtr): boolean;
procedure ShowNewFields(Entry: EntryRecPtr);
procedure IndexToBibExt(var f: string);

Implementation

{$IFNDEF WINDOWS}
const
  OpenFilesLogName = 'bibdb.opn';
{$ENDIF}

Var
  OldExitProc: Pointer;
{$IFNDEF WINDOWS}
  Open_Files_Called: boolean;
{$ENDIF}

  MaxMaxmAvail,MaxMemmAvail: longint;

procedure AllocStrings(make: boolean; P1,P2,P3,P4: PPstring);
begin
  if make then
  begin
    if P1<>Nil then begin New(P1^); P1^^:=''; end;
    if P2<>Nil then begin New(P2^); P2^^:=''; end;
    if P3<>Nil then begin New(P3^); P3^^:=''; end;
    if P4<>Nil then begin New(P4^); p4^^:=''; end;
  end else
  begin
    if (P4<>Nil) and (P4^<>Nil) then begin Dispose(P4^); P4^:=Nil; end;
    if (P3<>Nil) and (P3^<>Nil) then begin Dispose(P3^); P3^:=Nil; end;
    if (P2<>Nil) and (P2^<>Nil) then begin Dispose(P2^); P2^:=Nil; end;
    if (P1<>Nil) and (P1^<>Nil) then begin Dispose(P1^); P1^:=Nil; end;
  end;
end;            { AllocStrings }

{$IFNDEF WINDOWS}

procedure Restore_Mode;
var
  DoIt: boolean;
  CurVidMode: byte;
begin
  DoIt:=true;
  if FixedVideoMode>0 then DoIt:=false
  else begin
    Get_video_mode(CurVidMode);
    if (OldVidMode=CurVidMode) and ((not (OldVidMode in [2,3])) or
       (OldNumRows=MaxY)) then DoIt:=false;
  end;
  if DoIt then
  begin
    if OldVidMode in [2,3] then    { VGA }
    begin
      vgalines(OldNumRows);
    end else set_video_mode(OldVidMode);
  end else ClrScr;
end;

procedure Set_BibDB_Mode;
var
  DoIt: boolean;
  CurVidMode: byte;
begin
  if CurrentMode=0 then
  begin
    CurrentMode:=OldVidMode;
    CurrentLen:=OldNumRows;
  end;
  DoIt:=true;
  if FixedVideoMode>0 then DoIt:=false
  else begin
    Get_video_mode(CurVidMode);
    if (CurrentMode=CurVidMode) and ((not (CurrentMode in [2,3])) or
       (CurrentLen=MaxY)) then DoIt:=false;
  end;
  if DoIt then
  begin
    if CurrentMode in [2,3] then VgaLines(CurrentLen)
    else if CurrentMode<>0 then set_video_mode(CurrentMode);
  end;
  ScrLen:=MaxY; ScrWidth:=MaxX;
end;

{$ENDIF}

function StringRC(id: integer; S: string): string;
var
{$IFDEF WINDOWS}
  F: array[0..255] of char;
{$ENDIF}
  tmp: string;
begin
  tmp:='';
{$IFDEF WINDOWS}
  if LoadString(Hinstance,id,F,256)<>0 then tmp:=StrPas(F);
{$ELSE}
  tmp:=StringResource^.Get(id);
{$ENDIF}
  if S<>'' then StrRepl(tmp,'%s',S,1,1,255);
  StringRC:=tmp;
end;

procedure TeXWordGet(VAR Dest: string; var Sin; Slen: Word; var Ind: Word);
Var
  S: BigType ABSOLUTE Sin;
  macro: (none,slash,body);
  finish,InTeXLett: boolean;
begin
  Dest:='';
  if (Ind=0) or (Ind>Slen) then Exit;
  while (Ind<=Slen) and (S[Ind] in [#9,' ']) do inc(Ind);
  finish:=false; macro:=none;
  while (not finish) and (Ind<=Slen) do
  begin
    Dest:=Dest+S[Ind];
    if (macro<>body) and (S[Ind] in [#9,' ']) then finish:=true
    else if (macro<>slash) and (S[Ind]='\') then Macro:=Slash
    else if macro<>none then
    begin
      InTeXLett:=(S[Ind] in TexLett);
      if not InTeXLett then macro:=none
      else if (macro=slash) and InTeXLett then Macro:=body;
    end;
    inc(Ind);
  end;
  if (Dest<>'') and (Dest[length(Dest)] in [#9,' ']) then Dest[0]:=Pred(Dest[0]);
end;                            { TeXWordGet }

function Scopy(Var S: BigTypePtr; Beg,Num: LongInt) : string;
var
  i: LongInt;
  tmp: string;
begin
  tmp:='';
  if Num>255 then Num:=255;
  Move(S^[beg],tmp[1],num); tmp[0]:=Chr(Num);
{  for i:=0 to Num-1 do PStrCat(tmp,S^[beg+i],255);}
  Scopy:=tmp;
end;

function ScopyNS(Var S: BigTypePtr; Beg,Num: LongInt) : string;
var
  i,first: LongInt;
  tmp: string;
begin
  tmp:='';
  first:=0;
  while (first<=Num) and (S^[Beg+first]=' ') do Inc(first);
  for i:=first to Num-1 do PStrCat(tmp,S^[beg+i],255);
  ChrDelR(tmp,' ');
  ScopyNS:=tmp;
end;

Procedure Sdelete(Var S: BigTypePtr; Var Slen: word; Index,Num: longint);
var
  i,Snew: longint;
begin
  Snew:=Slen-Num; if Snew<0 then Snew:=0;
  for i:=Index to Snew do S^[i]:=S^[i+Num];
  Slen:=Snew; S^[Slen+1]:=#0;
end;

Procedure Sinsert(Var S: BigtypePtr; Var Slen: word; S_in: string;
                  Index: longint; MaxBig: Word);
var
  i,Smax,LS: longint;
  tmp: string;
begin
  LS:=length(S_in);
  If Index+LS<=MaxBig then
    for i:=imin(MaxBig,Slen+LS) downto Index+LS do S^[i]:=S^[i-LS];
  for i:=Index to imin(MaxBig,Index+LS-1) do S^[i]:=S_in[i-Index+1];
  Slen:=imin(Slen+LS,MaxBig); S^[Slen+1]:=#0;
end;

Procedure Cinsert(ch: Char; Var S: BigTypePtr; Var Slen: word;
                  Index: longint; MaxBig: Word);
var
  sch: string[1];
begin
  sch:=ch;
  Sinsert(S,Slen,sch,Index,MaxBig);
end;

function PlaceCompare(place1,place2: longint): shortint;
begin
  if place1=-1 then PlaceCompare:=1
  else if place2=-1 then PlaceCompare:=-1
  else if place1=place2 then PlaceCompare:=0
  else if place1<place2 then PlaceCompare:=-1
  else PlaceCompare:=1;
end;

procedure MaxMemAvail;
var
  m1,m2: longint;
begin
  m1:=MemAvail; m2:=MaxAvail;
  if m1<MaxMemmAvail then MaxMemmAvail:=m1;
  if m2<MaxMaxmAvail then MaxMaxmAvail:=m2;
end;

function imin(a1,a2: longint): longint;
begin
  if a1<=a2 then imin:=a1
  else imin:=a2;
end;

function imax(a1,a2: longint): longint;
begin
  if a1>=a2 then imax:=a1
  else imax:=a2;
end;

procedure Tag(realnum: longint; action: TagActionType; var Tags: TagType);
var
  i,mask: word;
begin
  if (realnum<=0) or (realnum>MaxTags) then Exit;
  i:=(realnum-1) div 16;
  mask := 1 SHL ((realnum-1) mod 16);
  case action of
    TagSet    : Tags[i]:=Tags[i] OR mask;
    TagClear  : Tags[i]:=Tags[i] AND (NOT mask);
    TagToggle : Tags[i]:=Tags[i] XOR mask;
  end;
end;

function IsTagged(realnum: longint; var Tags: TagType): boolean;
var
  i,mask: word;
begin
  if (realnum<=0) or (realnum>MaxTags) then IsTagged:=false
  else begin
    i:=(realnum-1) div 16;
    mask := 1 shl ((realnum-1) mod 16);
    IsTagged := (Tags[i] AND mask) <>0;
  end;
end;

procedure InsertNewTag(realnum: longint; var Tags: TagType);
var
  i,j,carry,ncarry: word;
begin
  if (realnum<=0) or (realnum>MaxTags) then exit;
  i:=(realnum-1) div 16;
  j:=(realnum-1) mod 16;
  carry:=Tags[i] shr 15;
  Tags[i]:=(Tags[i] AND (65535 SHR (16-j))) +
           ((Tags[i] SHL 1) AND ((65535 SHR (j+1)) SHL (j+1)));
  for j:=i+1 to ((MaxTags div 16)-1) do
  begin
    ncarry:=Tags[j] SHR 15;
    Tags[j]:=(Tags[j] SHL 1) + carry;
    carry:=ncarry;
  end;
end;

procedure DeleteOldTag(realnum: longint; var Tags: TagType);
var
  i,j,carry,ncarry: word;
begin
  if (realnum<=0) or (realnum>MaxTags) then exit;
  i:=(realnum-1) div 16;
  carry:=0;
  for j:=((MaxTags div 16)-1) downto i+1 do
  begin
    ncarry:=Tags[j] SHL 15;
    Tags[j]:=(Tags[j] SHR 1) + carry;
    carry:=ncarry;
  end;
  j:=(realnum-1) mod 16;
  Tags[i]:=(Tags[i] AND (65535 SHR (16-j))) +
           (((Tags[i] SHR 1) + carry) AND ((65535 SHR (j)) SHL (j)));
end;

function ContainsTags(Pattern: PatRecPtr): boolean;
var
  i: byte;
begin
  ContainsTags:=false;
  if Pattern=Nil then Exit;
  if Pattern^.on then
    for i:=1 to Pattern^.noper do
      if (Pattern^.operation[i]>0) and
         (Pattern^.field[Pattern^.operation[i],1]=PattField_Tagged)
        then ContainsTags:=true;
end;    

procedure EraseTags(var Tags: TagType);
begin
  FillChar(tags[0],(MaxTags div 8),0);
end;

procedure ResetBibFile(var f: text; name: string);
begin
  LFNReset(f,0);
  if DosError in [2,3,102,103] then ReachedEol:=false    { File not found }
  else if (DosError<>0) and (name<>'') and (not 
    AskIf(' I/O error '+num2str(DosError)+' while opening "'+name+'". ','',
        'Continue','Abort'))
      then Halt(255);
end;

procedure NewEntry(var Entry: EntryRecPtr);
var
  i: integer;
begin
  if entry=Nil then
  begin
    New(Entry);
    for i:=1 to MaxField do Entry^.big[i]:=Nil;
{$IFDEF WINDOWS}
    New(Entry^.BinList,init(100,100));
{$ELSE}
    for i:=1 to MaxNumberBig do GetMem(Entry^.big[i],MaxBig+1);
{$ENDIF}
  end;
  MaxMemAvail;
end;                { NewEntry }

procedure DisposeEntry(var Entry: EntryRecPtr);
var
  i: integer;
begin
  if Entry=Nil then Exit;
  for i:=1 to MaxNumberBig do
    if Entry^.big[i]<>Nil then FreeMem(Entry^.big[i],MaxBig+1);
{$IFDEF WINDOWS}
  Dispose(Entry^.BinList,Done);
{$ENDIF}
  dispose(Entry); Entry:=Nil;
end;

function EnoughMem(needed: longint): KeepModeType;
begin
  if ((not ForceKeepInStream) or (VirtualStream=Nil)) and
      (needed+MemoryPoolSize<MaxAvail) then
        EnoughMem:=KeepInMemory
  else if VirtualStream<>Nil then EnoughMem:=KeepInStream
  else begin
    EnoughMem:=DontKeep;{ message('not enough!');}
  end;
end;

procedure PushBufferStack(var S; len: word; KeepMode: KeepModeType;
                          StackPos: byte);
var
  place: byte;
begin
  if (StackPos=0) and (BuffStackInd=MaxBuffStack) then
    FatalErrorRC(Str_BufStackOverflow,'');
  place:=StackPos; if (StackPos=0) then
  begin
    Inc(BuffStackInd); place:=BuffStackInd; 
  end;
  with KeepStack^[Place] do
  begin
    Mode:=KeepMode;
    if StackPos=0 then
    begin
      if VirtualStream<>Nil then
      begin
        if place=1 then VFilePos:=0
        else VFilePos:=KeepStack^[place-1].VFilePos+KeepStack^[place-1].Klen;
        if VFilePos>VirtualStream^.getsize then VFilePos:=VirtualStream^.getsize;
      end else VFilePos:=-1;
    end;
    if (KeepMode=KeepInMemory) then
    begin
      if P=Nil then
      begin
        if len>0 then GetMem(P,len);
      end else if klen<>len then FatalErrorRC(Str_VmemError,'');
      if P<>Nil then move(S,P^,len);
      KLen:=len;
      MaxMemAvail;
    end else if KeepMode=KeepInStream then
    begin
      if VirtualStream<>Nil then
      begin
        VirtualStream^.seek(VFilePos);
        VirtualStream^.write(S,len);
        Klen:=len;
        if VirtualStream^.status<>stOK then FatalErrorRC(Str_VmemError,'');
      end else Mode:=DontKeep;
    end;
  end;
end;                    { PushBufferStack }

procedure RecallBufferStack(var S; StackPos: byte);
var
  place: byte;
  oldpos: longint;
  tmp: string[10];
begin
  if BuffStackInd=0 then exit;
  Place:=StackPos; if StackPos=0 then Place:=BuffStackInd;
  with KeepStack^[place] do
  begin
    if Mode=KeepInMemory then
    begin
      move(P^,S,klen);
    end else if (Mode=KeepInStream) and (VirtualStream<>Nil) then
    begin
      oldpos:=VirtualStream^.getpos;
      VirtualStream^.seek(VFilePos);
      VirtualStream^.read(S,klen);
      VirtualStream^.seek(oldPos);
    end;
  end;
end;                    { RecallBufferStack }

procedure RecallPartBufStack(var S; len: Word; StackPos: byte);
var
  place: byte;
  oldpos: longint;
  tmp: string[10];
begin
  if BuffStackInd=0 then exit;
  Place:=StackPos; if StackPos=0 then Place:=BuffStackInd;
  with KeepStack^[place] do
  begin
    if len>klen then len:=klen;
    if Mode=KeepInMemory then
    begin
      move(P^,S,len);
    end else if (Mode=KeepInStream) and (VirtualStream<>Nil) then
    begin
      oldpos:=VirtualStream^.getpos;
      VirtualStream^.seek(VFilePos);
      VirtualStream^.read(S,len);
      VirtualStream^.seek(oldPos);
    end;
  end;
end;                    { RecallPartBufStack }

procedure DiscardBufferStack;
begin
  if BuffStackInd=0 then exit;
  with KeepStack^[BuffStackInd] do
  begin
    if Mode=KeepInMemory then
    begin
      freemem(P,klen); P:=Nil;
    end;
    if (VirtualStream<>Nil) and (VFilePos>=0) then VirtualStream^.seek(VFilePos);
    VFilePos:=-1;
    klen:=0;
  end;
  Dec(BuffStackInd);
end;                    { DiscardBufferStack }

procedure PopBufferStack(var S);
begin
  RecallBufferStack(S,0);
  DiscardBufferStack;
end;

function StoreEntry(F: PStream; Entry: EntryRecPtr): boolean;
var
  ifld,i0,i1: integer;
  BinCount: longint;
  HasBinary: boolean;
begin                            { PutEntryTemp }
  StoreEntry:=false;
  if (F=Nil) or (F^.Status<>stOK) then Exit;
  HasBinary:=false;
{$IFNDEF WINDOWS}
    for ifld:=1 to Entry^.nentry do
      if Pos(BinaryFields^,Entry^.field[ifld])=1 then HasBinary:=true;
    if HasBinary and
      AskIf('Entry "'+Entry^.name+'" contains binary fields!','Warning',
           'Cancel','Save') then Exit;
{$ENDIF}

  F^.write(Entry^,sizeof(SaveEntryRec));
  with Entry^ do
  begin
    F^.write(Name[0],length(name)+1);
    F^.write(EntryType[0],length(EntryType)+1);
    i0:=1; I1:=LastField;
    if EditOnlyStrings then
    begin
      i0:=StringIndex; i1:=StringIndex;
    end;
    for ifld:=i0 to i1 do
    if index[ifld]>0 then
    begin
      F^.write(field[index[ifld]][0],length(field[index[ifld]])+1);
      if BigIndex[ifld]=0 then
        F^.write(content[index[ifld]][0],length(content[index[ifld]])+1)
      else begin
        F^.write(Blen[BigIndex[ifld]],sizeof(Word));
        F^.write(Big[BigIndex[ifld]]^[1],Blen[BigIndex[ifld]]);
      end;
    end;
{$IFDEF WINDOWS}
    BinCount:=BinList^.Count;
    F^.write(BinCount,SizeOf(BinCount));
    for i0:=0 to BinList^.Count-1 do PBinObject(BinList^.at(i0))^.Store(F^);
{$ENDIF}
  end;
  if F^.Status=stOK then StoreEntry:=true;
end;                         { StoreEntry }

function LoadEntry(F: PStream; Entry: EntryRecPtr): boolean;
var
  ifld,i0,i1: integer;
  BinCount: longint;
begin
  LoadEntry:=false;
  if (F=Nil) or (F^.Status<>stOK) then Exit; 
  ZeroEntry(Entry);
  F^.Read(Entry^,sizeof(SaveEntryRec));
  with Entry^ do
  begin
    name:=''; EntryType:=''; nentry:=0;
    GetString(F,name); GetString(F,EntryType);
    i0:=1; I1:=LastField;
    if EditOnlyStrings then
    begin
      i0:=StringIndex; I1:=StringIndex;
    end;
    for ifld:=i0 to i1 do
    if index[ifld]>0 then
    begin
      inc(nentry);
      GetString(F,field[index[ifld]]);
      if BigIndex[ifld]=0 then
        GetString(F,content[index[ifld]])
      else begin
        BigFree[BigIndex[ifld]]:=false;
        F^.read(Blen[BigIndex[ifld]],sizeof(Word));
        F^.read(Big[BigIndex[ifld]]^[1],Blen[BigIndex[ifld]]);
        Move(Big[BigIndex[ifld]]^[1],content[index[ifld]][1],255);
        content[index[ifld]][0]:=#255;
      end;
    end;
{$IFDEF WINDOWS}
    F^.Read(BinCount,sizeof(BinCount));
    for i0:=1 to BinCount do BinList^.Insert(New(PBinObject,Load(F^)));
{$ENDIF}
  end;
  if F^.Status=stOK then LoadEntry:=true;
end;                        { LoadEntry }

procedure ZeroSortMode(var M: ConfigSortType; Pattern: PatRecPtr);
var
  i: integer;
  bool: boolean;
begin
  if Pattern<>Nil then
  with Pattern^ do
  begin
    noper:=0; npatt:=0; on:=false;
  end;
  with M do
  begin
    StringNameSort:=StrSortOff;
    MixedCollation:=true;
    SortingOn:=false;
    UsePatternFile:=false;
    SortPatternExists:=false;
    SortPatternFile:='';
    PattFirst:=true;
    SortTypeOrder:='';
    for bool:=false to true do
    begin
      for i:=1 to NSortKeys do
      begin
        SortKey[i,bool]:='';
        KeyAsc[i,bool]:=true;
        NullKeyFirst[i,bool]:=true;
      end;
      NameAsc[bool]:=true;
    end;
  end;
end;                                { ZeroSortMode }

procedure ZeroEntry(Entry: EntryRecPtr);
var
  i,j: integer;
begin                           { ZeroEntry }
{$IFNDEF WINDOWS}
  i:=1;
  while (i<=FieldLast) do
  begin
    if Pos(BinaryFields^,TypeField^[i])=1 then  { Binary field, remove }
    begin
      for j:=i to FieldLast-1 do
      begin
        TypeField^[j]:=typefield^[j+1];
        DumpFields[j]:=DumpFields[j+1];
        if FieldParams^[j].AltName<>Nil then DisposeStr(FieldParams^[j].AltName);
        FieldParams^[j]:=FieldParams^[j+1];
      end;
      dec(FieldLast);
    end else inc(i);
  end;
{$ENDIF}
  with entry^ do
  begin
    nentry:=0; realnum:=0; entrynum:=0;
    name:='';
    LastField:=DefFieldLast;
    FillChar(Beginning,sizeof(beginning),0);
    FillChar(Ending,sizeof(ending),0);
    for i:=1 to maxfield+1 do
    begin
      if i<=maxfield then content[i]:='';
      index[i]:=0;
      BigIndex[i]:=0;
    end;
    for i:=1 to MaxNumberBig do
    begin
      BigFree[i]:=true; Blen[i]:=0;
    end;
{$IFDEF WINDOWS}
    BinList^.FreeAll;
{$ENDIF}
  end;
  fieldlast:=DefFieldLast;
end;                                    { ZeroEntry }

procedure ResetBib(Entry: EntryRecPtr);
begin                                     { ResetBib }
  ZeroEntry(Entry); Entry^.EntryType:='';
  LastReadLine^:='';
  if BibFileExists then
  begin
    FlushFile(bib);
    if Linked then
    begin
      BibInRing:=1;
      bibname^:=BibFiles^[BibRing[1]].name;
      BibReadOnly:=BibFiles^[BibRing[BIbInRing]].RO;
      LFNClose(bib);
      LFNAssign(bib,bibname^);
      {
      BibFiles[BibRing^[1]].entrystart:=0;
      BibFiles[BibRing^[1]].realstart:=0;
      }
      CurrentBibFile:=BibRing[1];
    end;
  end;
  UnixBib:=IsUnixFile(bib,bibname^);
  ResetBibFile(bib,bibname^);
  SetTextBuf(bib,bibbuf^,FileBufSize);
  suspended:=false;
  AtStartOfFile:=true; ReachedEOL:=false;
end;                                      { ResetBib }

{$IFNDEF WINDOWS}
Procedure FatalError(S: String);
begin                       { FatalError }
  if ErrorFormat=init then
  begin
    writeln; writeln(S);
  end else if ErrorFormat=config then
  begin
    writeln; writeln('Configuration file error:');
    writeln('   ',S);
  end else
  ErrorMessage(S);
  Halt(255);
end;                         { FatalError }

procedure FatalErrorRC(id: word; S: string);
begin
  ErrorMessageRC(id,S);
  Halt(255);
end;

procedure ContextHelp(Context: string);
var
  hlp: text;
  line,CompStr: string;
  found: boolean;
  ch: char;
  i,wid,hei,x0,y0: integer;
  HlpFile,D,N: string;
begin
  if Context='' then Exit;
  LFNFSplit(ProgramFile^,@D,@N,Nil);
  FindFile(HlpFile,N+HelpFileExtension^,D);
  if HlpFile='' then
  begin
    ErrorMessage(' Can''t find help file! '); Exit;
  end;
  CompStr:='['+Context+']'; StrLwr(CompStr);
  LFNNew(hlp,true); LFNAssign(hlp,hlpfile);
  LFNReset(hlp,0);
  found:=false;
  while (not eof(hlp)) and (not found) do
  begin
    readln(hlp,line); StrLwr(line);
    if line=CompStr then found:=true;
  end;
  if not found then
  begin
    LFNDispose(hlp); Exit;
  end;
  readln(hlp,wid,hei,line); ChrDelL(line,' ');
  if wid<2 then wid:=2; if wid>ScrWidth-6 then wid:=ScrWidth-6;
  if hei<1 then hei:=1;
  y0:=(25-1-hei) div 2; x0:=(ScrWidth-4-wid) div 2;
  if (ScrLen>25) and (y0<5) then y0:=5;
  readln(hlp);
  if ErrorFormat<>Normal then
  begin
    for i:=1 to hei do
    begin
      readln(hlp,line); Writeln(line);
    end;
  end else
  begin
    CursorOff;
    if hei>ScrLen-3 then hei:=ScrLen-3;
    if UseMouse then
    begin
      ShowMouseCursor; ShowMouseCursor;
      HideMouseCursor;
    end;
    MakeWindow(y0,x0,Hei+3,wid+4,MessageNorm,MessageNorm,2,RNorm,Shadow,0);
    MaxMemAvail;
    Titlewindow(2,MessageNorm,line);
    for i:=1 to hei do
    begin
      readln(hlp,line);
      PrtWindow(i+1,2,line);
    end;
    if UseMouse then 
    begin
      WaitForRelease(255);
      ShowMouseCursor;
    end;
    CLB;
    ch:=ReadKeyMouse;
    if ch=#0 then ch:=ReadKey;
    if UseMouse then HideMouseCursor;
    RemoveWindow;
    if UseMouse then WaitForRelease(255);
  end;
  LFNDispose(hlp);
end;                            { ContextHelp }

procedure Open_Files(S: string);
{ Diagnostic routine, which prints out a list of currently open files. }
var
  LogFile: text;
begin
  assign(LogFile,OpenFilesLogName);
  if Open_Files_Called then
  begin
    Append(LogFile); writeln(LogFile);
  end else rewrite(LogFile);
  Writeln(LogFile,'---------',S,'---------');
  print_open_files(LogFile);
  close(LogFile);
  Open_Files_Called:=true;
end;                              { Open_Files }
{$ENDIF}

function FindBigFree(Entry: EntryRecPtr; reserve: boolean): Byte;
var
  iaux,i: integer;
begin                                   { FindBigFree }
  iaux:=0; i:=1;
  while (i<=MaxNumberBig) and (iaux=0) do
  begin
    if Entry^.BigFree[i] then
    begin
{$IFDEF WINDOWS}
      if Entry^.Big[i]=Nil then
      begin
        GetMem(Entry^.Big[i],MaxBig+1);
{        message('allocate slot '+num2str(i));}
      end;
{$ENDIF}
      if reserve then Entry^.BigFree[i]:=false;
      iaux:=i;
    end;
    inc(i);
  end;
  if reserve and (iaux=0) and (Verbosity>1) then ErrorMessageRC(Str_TooManyBig,'');
  FindBigFree:=iaux;
end;                                    { FindBigFree }

function OkField(var S1; slen: word; Verb: byte;
                 ErrorBraces,ErrorMacros: string;
                 var BareQuote: boolean): boolean;
var
  S: BigType ABSOLUTE S1;
  i: Word;
  nbr: integer;
  ok,spaces,braces,SkipBlanks,cat,WithQuote: boolean;
  tmp: string;
  add: string[3];
begin
  OkField:=true;
  BareQuote:=false;
  if slen<1 then Exit;
  ok:=true;
  if S[1]<>'@' then
  begin
    nbr:=1; i:=1;
    while (i<=slen) and ok do
    begin
      if (S[i] in [lbrace,rbrace]) and
         ((i=1) or (not EscapeBraces) or (S[i-1]<>'\')) then
      begin
        if S[i]=lbrace then inc(nbr)
        else dec(nbr);
      end else if (S[i]='"') and (nbr=1) and ((i=1) or (S[i-1]<>'\')) then
        BareQuote:=true;
      if nbr<1 then ok:=false;
      inc(i);
    end;
    if nbr<>1 then ok:=false;
    if (not ok) and (Verb>2) and (ErrorBraces<>'') then ErrorMessage(ErrorBraces);
    OkField:=ok;
    Exit;
  end;
  if slen<2 then Exit;
  spaces:=false; i:=2; nbr:=0; braces:=true;
  while (i<=slen) and (S[i]=' ') do inc(i);
  cat:=false;
  while (i<=slen) and ok do
  begin
    if nbr=0 then
    begin
      cat:=false;
      SkipBlanks:=false;
      if S[i]='#' then
      begin
        spaces:=false;
        SkipBlanks:=true;
        cat:=true;
      end else if S[i]=' '  then
      begin
        spaces:=true;
        SkipBlanks:=true;
      end else if ((S[i]='"') and (S[i-1]<>'\')) or
                  ((S[i]=lbrace) and ((S[i-1]<>'\') or not EscapeBraces)) then
      begin
        inc(nbr);
        braces:=(S[i]=lbrace);
      end else if spaces then ok:=false;
    end else if (S[i] in [lbrace,rbrace]) and
                ((S[i-1]<>'\') or not EscapeBraces) then
    begin
      if S[i]=lbrace then inc(nbr)
      else begin
        if braces or (nbr>1) then dec(nbr)
        else ok:=false;   { Not sure about this (unbalanced braces in "" string) }
      end;
    end else if (not braces) and (S[i]='"') and (S[i-1]<>'\') and (nbr=1) then
      dec(nbr);
    inc(i);
    if SkipBlanks then
      while (i<=Slen) and (S[i]=' ') do inc(i);
  end;
  if (nbr<>0) or cat then ok:=false;
  if (Verb>2) and (not ok) and (ErrorMacros<>'') then ErrorMessage(ErrorMacros);
  OkField:=ok;
end;                        { OkField }

Procedure Capitalize(S: BigTypePtr; Var Slen: Word; Start,Finish: Word;
                     author: boolean);
const
  NnoCap=2;
  NoCap : array[1..Nnocap] of string[6] = ('and','or');
  StartSentence = ['.',':','!','?'];
  EtAlStr = ' and others';
var
  i,j,Br,Index,Ind2,k,L: LongInt;
  LastSep,Art,BegSentence,Math: Boolean;
  ch,delimiter: char;
  tmp: string;
  IsAt,FinishUp,NoLett: Boolean;
  Letters: set of char;
begin                             { Capitalize }
  if (Slen=0) or (Slen<Start) or (Start>=Finish) then Exit;
  Letters:=['A'..'Z','0'..'9','\','@','#','_',#21,#128..#255]+CtrlStartChars;
  if Start=0 then
  begin
    Start:=1; Finish:=Slen;
  end;
  if Finish>Slen then Finish:=Slen;
  if author and (Finish=Slen) then
  begin
    tmp:='';
    i:=Slen; j:=0;
    while (i>0) and (length(tmp)<length(EtAlStr)) and ((j<2) or (S^[i]<>' ')) do
    begin
      tmp:=S^[i]+tmp;
      if S^[i]=' ' then inc(j);
      dec(i);
    end;
    if tmp=EtAlStr then Finish:=Finish-length(EtAlStr);
  end;
  Finish:=Slen-Finish;
  index:=Start;
  LastSep:=true;
  Br:=0;
  IsAt:=(S^[1]='@') and (Start=1); if IsAt then Br:=-1;
  BegSentence:=true;
  Math:=false;
  repeat
    L:=Slen;
    ch:=UpCase(S^[index]);
    if (ch in Letters) and (not Math) then
    begin
      if (Br=0) and LastSep then
      begin
        k:=index;
        repeat
          Inc(k);
          if k<=Slen then ch:=UpCase(S^[k]);
        until (k>Slen) or (not (ch in Letters));
        if k>Slen then
        begin
          k:=Slen;
          tmp:=SCopy(S,index,Slen-index+1);
        end else tmp:=SCopy(S,index,k-index);
        if index=1 then Art:=false
        else Art := (S^[index-1] in ['''']);
        for i:=1 to narticles do
          if (Articles[i]^=tmp) and (S^[index+length(tmp)]<>'.') then Art:=true;
        if (Index>1) and BegSentence then
        begin
          for i:=1 to NnoCap do if NoCap[i]=tmp then BegSentence:=false;
        end;
        if (not Art) or (BegSentence and not author) then
        begin
          Ind2:=index-1;
          while (Ind2>0) and (S^[ind2] in [' ',#9]) do dec(Ind2);
          NoLett:=true;
          while (Ind2>0) and (S^[ind2] in TeXLett) do 
          begin
            NoLett:=false;
            dec(Ind2);
          end;
          if (NoLett) or (not(S^[index] in TexLett)) or (Ind2=0) or 
             (S^[ind2]<>'\') then
          begin
            if Ord(S^[index])>127 then
            begin
              if S^[index] in HighLows then
              begin
                i:=Pos(S^[Index],HighUpper^[1]);
                if i>0 then S^[Index]:=HighUpper^[2,i]
                else begin
                  i:=1;
                  while (i<=NTranslate) and (S^[index]<>Translate^[i].c) do
                    Inc(i);
                  if S^[index]=Translate^[i].c then
                  begin
                    tmp:=translate^[i].S^;
                    i:=length(tmp);
                    if tmp[i]=' ' then
                    begin
                      tmp[i-1]:=UpCase(tmp[i-1]);
                      if (i>2) and (tmp[i-2]='\') and (tmp[i-1]='I') then
                        tmp:=Copy(tmp,1,i-3)+'I';
                    end else tmp[i]:=UpCase(tmp[i]);
                    i:=length(tmp);
                    if Slen+i<=MaxBig then
                    begin
                      for j:=Slen downto index+1 do S^[j+i]:=S^[j];
                      S^[Index]:='\';
                      for j:=1 to i do S^[Index+j]:=tmp[j];
                      Slen:=Slen+i;
                    end;
                  end;
                end;
              end;
            end else
            begin
              S^[index]:=UpCase(S^[index]);
              if (S^[index]='\') and (index+1=Slen) and
                 (UpCase(S^[index+1])='O') then
                   S^[index+1]:='O'
              else if (index+2<=Slen) and (S^[index]='\') and
                (S^[index+1] in CtrlStartChars) then
              begin
                if S^[index+1]='a' then
                begin
                  tmp:=S^[index+1]+S^[index+2];
                  if ((tmp='aa') or (tmp='ae')) and
                     ((index+2=Slen) or not (S^[index+3] in TexLett)) then
                  begin
                    S^[index+1]:=UpCase(S^[index+1]);
                    S^[index+2]:=UpCase(S^[index+2]);
                  end;
                end else if (S^[index+1]='o') then
                begin
                  tmp:=S^[index+1]+S^[index+2];
                  if (tmp='oe') and
                     ((index+2=Slen) or not (S^[index+3] in TexLett)) then
                  begin
                    S^[index+1]:=UpCase(S^[index+1]);
                    S^[index+2]:=UpCase(S^[index+2]);
                  end else if not (S^[index+2] in TexLett) then
                    S^[index+1]:=UpCase(S^[index+1])
                end else if (index+3<=Slen) and (S^[index+2]='\') and
                            (S^[index+3]='i') and 
                  ((index+4>Slen) or (not (S^[index+4] in TexLett)) ) then
                begin
                  S^[index+2]:='I';
                  for j:=index+3 to Slen-1 do S^[j]:=S^[j+1];
                  Dec(Slen);
                  if (index+3<=Slen) and (S^[index+3]=' ') then
                  begin
                    for j:=index+3 to Slen-1 do S^[j]:=S^[j+1];
                    Dec(Slen);
                  end;
                end else if (index+5<=Slen) and (S^[index+2]=lbrace)
                  and (S^[index+3]='\') and (S^[index+4]='i')
                  and (S^[index+5]=rbrace) then
                begin
                  S^[index+2]:='I';
                  for j:=index+3 to Slen-3 do S^[j]:=S^[j+3];
                  Slen:=Slen-3;;
                end else if (index+3<=Slen) and
                  ((S^[index+2]=lbrace) or (S^[index+1]='c')) then
                    S^[index+3]:=UpCase(S^[index+3])
                else if not (S^[index+1] in TeXLett) then
                  S^[index+2]:=UpCase(S^[index+2]);
              end;
            end;
          end;
        end;
      end;
      LastSep:=false;
      BegSentence:=false;
    end else if (ch=lbrace) or ((Br=-1) and (ch='"')) then
    begin
      if (index=1) or (S^[index-1]<>'\') then
      begin
        Inc(Br);
        BegSentence:=false;
      end;
      if Br=-1 then
      begin
        if ch=lbrace then delimiter:=rbrace
        else delimiter:='"';
      end;
    end else if (ch=rbrace) or (IsAt and (Br=0) and (ch='"')) then
    begin
      if (index=1) or (S^[index-1]<>'\') then
      begin
        if Br>0 then Dec(Br);
        BegSentence:=false;
      end;
    end else if (ch in StartSentence) and (Br=0) and (not Math) then
             BegSentence:=true
    else if (Br=0) and (ch='$') and ((index=1) or (S^[index-1]<>'\')) then
         Math:=not Math
    else LastSep:=true;
    if BegSentence or math then LastSep:=true;
    Inc(Index);
  until (Slen-Index)<Finish;
end;                           { Capitalize }

function FindInFieldList(S: string): integer;
var
  FoundExact,FoundPartial,Npartial,i: integer;
begin
  FoundExact:=0;
  FoundPartial:=0; NPartial:=0;
  StrLwr(S);
  i:=0;
  repeat
    if i<FieldLast then inc(i)
    else i:=StringIndex;
    if S=Typefield^[i] then FoundExact:=i
    else if Pos(S,Typefield^[i])=1 then
    begin
      FoundPartial:=i; inc(Npartial);
    end;
  until (i=StringIndex) or (FoundExact>0);
  if FoundExact>0 then FindInFieldList:=FoundExact
  else if Npartial=1 then FindInFieldList:=FoundPartial
  else FindInFieldList:=0;
end;                       { FindInFieldList }

function FindInETypeList(S: string): integer;
var
  FoundExact,FoundPartial,Npartial,i: integer;
begin
  FoundExact:=0;
  FoundPartial:=0; NPartial:=0;
  StrLwr(S);
  i:=0;
  repeat
    inc(i);
    if S=TypeEntry^[i] then FoundExact:=i
    else if Pos(S,TypeEntry^[i])=1 then
    begin
      FoundPartial:=i; inc(Npartial);
    end;
  until (i=PreambleTypeInd) or (FoundExact>0);
  if FoundExact>0 then FindInETypeList:=FoundExact
  else if Npartial=1 then FindInETypeList:=FoundPartial
  else FindInETypeList:=0;
end;                            { FindInETypeList }

procedure ShowPathList(PathList: PathListPtr);
begin
  while PathList<>Nil do
  begin
    if PathList^.P<>Nil then message(PathList^.P^);
    PathList:=PathList^.Next;
  end;
end;

procedure ReadSortRec(F: PStream; var Srec: SortRecType);
var
  i: integer;
begin
  with Srec do
  begin
    F^.read(place,sizeof(place));
    F^.read(size,sizeof(size));
    F^.read(Ereal,sizeof(Ereal));
    GetString(F,name);
    if EditOnlyStrings then
    begin
      with Srec do
      begin
        Patt:=true;
        for i:=1 to NSortKeys do Keys[i]:='';
      end;
    end else
    begin
      F^.read(Patt,sizeof(Patt));
      for i:=1 to NSortKeys do GetString(F,keys[i]);
    end;
    if F^.Status<>stOK then
    begin
      name:=''; F^.Reset;
    end;
    ChrDel(name,' ');
  end;
end;                                { ReadSortRec }

procedure FindSortRec(var Srec: SortRecType; Num: longint; var ok: boolean);
var
  i: longint;
  IndexFile: PSafeBufStream;
begin
  ok:=false; IndexFile:=Nil;
  if (IndexFileName^='') or (NumberOfEntries<=0) then Exit;
  if (num<=0) or (Num>NumberOfEntries) then Exit;
  ok:=true;
  New(IndexFile,Init(IndexFileName^,stOpenRead,WorkBufSize));
  IndexFile^.seek(EndOfIndexHeader);
  for i:=1 to num do ReadSortRec(IndexFile,Srec);
  if IndexFile^.status<>stOK then
  begin
    ErrorMessageRC(Str_RWIndexError,'');
    NumberOfEntries:=0; IndexFileName^:=''; ok:=false;
  end;
  Dispose(IndexFile,Done);
end;                               { FindSortRec }

function MakeUseOfIndex(Pattern: PatRecPtr): boolean;
begin
  MakeUseOfIndex:=UseIndexFile and
      ((Pattern=Nil) or (not Pattern^.on)) and (IndexFileName^<>'')
      and (not linked) and (not EditOnlyStrings) and (NumberOfEntries>0)
      and (not DisableIndexFile);
end;

{$IFNDEF WINDOWS}
procedure LoadStringAbbrevs(var T: char; Entry: EntryRecPtr);
begin end;
{$ENDIF}

procedure StripBraces(var S: string; var BrDepth: integer;
                      var ExtraBrace,Math: boolean);
var
  i,j: integer;
begin
  if (not StripExtraBraces) or (S='') then Exit;
  i:=1;
  while (i<=length(S)) do
  if ((S[i]<>lbrace) and (S[i]<>rbrace) and (S[i]<>'$')) or
     ((i>1) and (S[i-1]='\')) then inc(i)
  else if S[i]='$' then
  begin
    if (i<length(S)) and (S[i+1]='$') then inc(i);
    Math:=not Math;
    inc(i);
  end else if S[i]=rbrace then
  begin
    if (BrDepth=1) and ExtraBrace then
    begin
      Delete(S,i,1); ExtraBrace:=false;
    end else inc(i);
    dec(BrDepth);
  end else if BrDepth>0 then
  begin
    inc(BrDepth); inc(i);
  end else
  begin
    ExtraBrace:=false;
    if (i>=length(S)) or (S[i+1]='\') or Math
      or ((i>1) and (S[i-1] in [rbrace,'['])) then inc(i)
    else begin
      j:=i-1;
      while (j>0) and (S[j]=' ') do dec(j);
      while (j>0) and (S[j] in TexLett+['''','"','`','~']) do dec(j);
      if (j=0) or (S[j]<>'\') then
      begin
        ExtraBrace:=true; Delete(S,i,1);
      end else inc(i);
    end;
    inc(BrDepth);
  end;
end;                                { StripBraces }

procedure ProtectMixedCase(S: BigTypePtr; var SLen: word; MaxBig: word;
                           ProtCap: boolean);
const
  BreakChars: string[7]='-.,:?!~';
var
  S1: BigTypePtr;
  tmp,tmp2: String;
  i,j,k,l,m,OldJ,OldLen,NewSLen,OrigLen,i0: word;
  nbr,nbr1,OldNbr: integer;
  IsCap,IsMacro,Overflow: boolean;
  EndChar: char;  
  BreakSet: set of char;

procedure AddStr(line: string);
begin
  if Overflow then Exit;
  if NewSLen+length(line)>MaxBig then Overflow:=true
  else begin
    Move(line[1],S^[NewSLen+1],length(line));
    NewSLen:=NewSLen+length(line);
  end;                
end;

begin                      { ProtectMixedCase }
  if (SLen<=1) then Exit;
  BreakSet:=[]; for k:=1 to length(BreakChars) do BreakSet:=BreakSet+[BreakChars[k]];
  OrigLen:=SLen;
  GetMem(S1,SLen+1); Move(S^,S1^,SLen);
  j:=1; nbr:=0; OldNBR:=0; NewSLen:=0; IsMacro:=false; Overflow:=false;
  if S^[1]='@' then   { Macro }
  begin
    IsMacro:=true;
    NewSLen:=1; nbr:=-1; j:=2;
  end;
  tmp:='';
  while (tmp<>'') or ((j>0) and (j<SLen)) do
  begin
{    message('Start <'+tmp+'>, '+num2str(nbr));}
    IsCap:=false;
    if tmp='' then
    begin
      OldJ:=j;
      TeXWordGet(tmp,S1^,SLen,j);
      { Escaped chars }
      for k:=2 to length(tmp) do
      if tmp[k-1]='\' then
      begin
        if IsMacro and (tmp[k]='"') then tmp[k]:=#1
        else if EscapeBraces and (tmp[k]=lbrace) then tmp[k]:=#2
        else if EscapeBraces and (tmp[k]=rbrace) then tmp[k]:=#3
        else if (tmp[k] in BreakSet) then tmp[k]:=Chr(Pos(tmp[k],BreakChars)+3);
      end;
      if (tmp<>'') and (OldJ>1) and (S1^[OldJ-1]=' ') then AddStr(' ');
{      message('Read <'+tmp+'>, '+num2str(nbr));}
    end;

    if tmp='' then
    else if (nbr=-1) then
    begin
      while (tmp<>'') and not (tmp[1] in ['"',lbrace]) do
      begin
        AddStr(tmp[1]); delete(tmp,1,1);
      end;
      if tmp<>'' then
      begin
        EndChar:=tmp[1]; if EndChar=lbrace then EndChar:=rbrace;
        AddStr(tmp[1]); Delete(tmp,1,1);
        inc(nbr);
      end;
    end else if IsMacro and (nbr=0) and (tmp[1]=EndChar) then
    begin
      AddStr(tmp[1]); Delete(tmp,1,1); dec(nbr);
    end else
    begin
      k:=1; nbr1:=nbr;
      if not IsMacro then k:=length(tmp)+1
      else while (k<=length(tmp)) and (nbr1>=0) do
      begin
        if tmp[k]=lbrace then inc(nbr1)
        else if ((nbr1=0) and (tmp[k]=EndChar)) or ((nbr1>0) and (tmp[k]=lbrace))
           then dec(nbr1);
        if nbr1>=0 then inc(k);
      end;
      OldLen:=length(tmp);
      tmp[0]:=Chr(k-1);

      m:=1;
      { Skip over leading separators }
      l:=m;
      while (l<=length(tmp)) and (tmp[l] in BreakSet) do inc(l);
      if (l>m) then AddStr(Copy(tmp,m,l-m));
      m:=l;
      { Loop over words in the string }
      while (m<=length(tmp)) do
      begin
        l:=m;
        while (l<=length(tmp)) and not (tmp[l] in BreakSet) do inc(l);
        if l<=m then tmp2:='' else tmp2:=Copy(tmp,m,l-m);
        m:=l;
        { Found a word }
        IsCap:=false;

        if (tmp2<>'') and (nbr=0)
            and (Pos('\',tmp2)+Pos(lbrace,tmp2)+Pos(rbrace,tmp2)=0) then
        begin     { Look for capital letters }
          i0:=1; while (i0<=length(tmp2)) and not (tmp2[i0] in TexLett) do inc(i0);
          if not ProtCap then inc(i0);
          for i:=i0 to length(tmp2) do
            if (tmp2[i] in ['A'..'Z']) then IsCap:=true;
        end else nbr:=nbr+ChrQty(tmp2,lbrace)-ChrQty(tmp2,rbrace);
        if tmp2<>'' then
        begin
          if IsCap then AddStr(lbrace);
          AddStr(tmp2);
          if IsCap then AddStr(rbrace);
        end;
        { Skip over separators }
        l:=m;
        while (l<=length(tmp)) and (tmp[l] in BreakSet) do inc(l);
        if (l>m) then AddStr(Copy(tmp,m,l-m));
        m:=l;
      end;
      tmp[0]:=Chr(OldLen); Delete(tmp,1,k-1);
    end;
    OldNbr:=nbr;
  end;
  if Overflow then Move(S1^,S^,SLen)
  else begin
    SLen:=NewSLen; S^[SLen+1]:=#0;
    { Restore escaped chars }
    for i:=1 to SLen do
      if S^[i]=#1 then S^[i]:='"'
      else if S^[i]=#2 then S^[i]:=lbrace
      else if S^[i]=#3 then S^[i]:=rbrace
      else if Ord(S^[i])<=3+length(BreakChars) then
        S^[i]:=BreakChars[Ord(S^[i])-3];
  end;

  FreeMem(S1,OrigLen+1);
end;                     { ProtectMixedCase }

procedure WinYield;
{$IFDEF WINDOWS}
var
  Mess: TMSG;
  SysComm,Allow: boolean;
begin
  if AmWaiting and PeekMessage(Mess,0,wm_KeyDown,wm_KeyDown,
                                        pm_NoRemove or pm_NoYield) and
     (Mess.lParam and (wmChar_ExtendedKey or wmChar_AltPressed or
        wmChar_KeyWasDown or wmChar_BeingReleased) = 0 ) and
     (GetKeyState(vk_Control)<0) and
     (LoByte(HiWord(Mess.lParam))=LoWord(OEMKeyScan(Ord('C'))))
  then                              { Ctrl+C }
    AbortFlag:=YesNoRC(Str_VerifyAbort,'');

  if WinYieldStep<=0 then Exit;
  inc(WinYieldCounter);
  if WinYieldCounter<WinYieldStep then Exit;
  WinYieldCounter:=0;
  if PeekMessage(Mess,0,0,0,pm_Remove) then
  with Mess do
  begin
    Allow:=true;
    Allow:=Allow and not ((Message>=wm_MouseFirst) and (Message<=wm_MouseLast));
    if ((Message>=wm_KeyFirst) and (Message<=wm_KeyLast)) then
    begin
      SysComm:=false;
      if ((Message=wm_KeyDown) or (Message=wm_SysKeyDown)) and     { A key press }
         (lParam and (wmChar_ExtendedKey or wmChar_KeyWasDown
                                   or wmChar_BeingReleased)=0) then
      begin
        SysComm:=(lParam and wmChar_AltPressed<>0) and
            ((wParam=vk_Tab) or (wParam=vk_Escape));   { Alt+Esc and Alt+Tab }
        SysComm:=SysComm or ((wParam=vk_Escape) and
                           (GetKeyState(vk_Control)<0));  { Ctrl+Esc }
      end;
      Allow:=Allow and SysComm;
    end;
    Allow:=Allow and (Message<>wm_Command);
    Allow:=Allow and ((Message<>wm_Paint) or (CurrentWindow=MainW));

    if Allow then
    begin
      TranslateMessage(Mess);
      DispatchMessage(Mess);
    end
  end;
{$ELSE}
begin
{$ENDIF}
end;

function ActivePattern(Pattern: PatRecPtr): boolean;
begin
  ActivePattern:=(Pattern<>Nil) and Pattern^.on;
end;

procedure ShowNewFields(Entry: EntryRecPtr);
var
  tmp: string;
  i,olast,added: integer;
  AreNew,HasBinary: boolean;
begin
  olast:=DefFieldLast;
  AreNew:=Entry^.LastField>DefFieldLast;
  if AreNew then DefFieldLast:=Entry^.LastField;
  if MacroCommand or (Verbosity<2) or (Entry^.LastField=olast) then Exit;
  tmp:=''; HasBinary:=false; Added:=0;
  with Entry^ do
  begin
    for i:=olast+1 to LastField do
    begin
{$IFNDEF WINDOWS}
      if Pos(BinaryFields^,field[index[i]])=1 then
      begin
        if not HasBinary then
        begin
          if tmp='' then tmp:='<binary data>'
          else tmp:=tmp+', <binary data>';
          inc(Added);
        end;
        HasBinary:=true;
      end else
      begin
{$ENDIF}
        if tmp='' then tmp:='"'+field[index[i]]+'"'
        else tmp:=tmp+', "'+field[index[i]]+'"';
        inc(Added);
{$IFNDEF WINDOWS}
      end;
{$ENDIF}
    end;
    if tmp<>'' then
    begin
      if Added=1 then MessageRC(Str_AddedField,tmp)
      else if Added>1 then MessageRC(Str_AddedFields,tmp);
    end;
  end;
end;                          { ShowNewFields }

procedure IndexToBibExt(var f: string);
var
  i: integer;
begin
  i:=length(f);
  while (i>0) and not (f[i] in ['.','\','/']) do dec(i);
  if (i>0) and (f[i]='.') and
               (StrCmpI(Copy(f,i,255),IndexExtension^,1,1,255)=0) then
      f:=Copy(f,1,i-1)+DefExtension[BibTeXFormat]^;
end;              { IndexToBibExt }

{$IFDEF WINDOWS}

{$F+}
type
  PRuntimeErrDlg = ^TRuntimeErrDlg;
  TRuntimeErrDlg = object(TDialog)
    ErrNum: integer;
    ErrPoint: pointer;
    F: array[0..255] of char;
    S: string;
    fl: text;
    constructor init(AErrNum: integer; AErrPoint: pointer);
    procedure   SetupWindow; virtual;
    procedure   ok(var Msg: TMessage); virtual id_first+id_ok;
  end;

constructor TRuntimeErrDlg.init(AErrNum: integer; AErrPoint: pointer);
begin
  TDialog.init(Nil,PChar(rc_RuntimeErrorDlg));
  ErrNum:=AErrNum; ErrPoint:=AErrPoint;
end;

procedure TRuntimeErrDlg.SetupWindow;
var
  SegAddr: Word;
begin
  TDialog.SetupWindow;
  SegAddr:=Seg(ErrPoint^);
  asm
    mov   bx, SegAddr
    verr  bx
    je    @1
    mov   bx,$FFFF
    jmp   @2
@1:
    mov   es,bx
    mov   bx,word ptr es:0
@2:
    mov   SegAddr,bx
  end;
  S:=LFNLongName(ParamStr(0));
  CanonicalFname(S);
  StrRepl(S,'.exe','.log',1,255,255);
  StrRepl(S,'.EXE','.LOG',1,255,255);
  StrPCopy(F,S);  SetDlgItemText(HWindow,dl_RuntimeErrorFile,F);
  GetDlgItemText(HWindow,dl_RuntimeErrText,F,255); S:=StrPas(F);
  StrRepl(S,'#1',num2str(ErrNum),1,255,255);
  StrRepl(S,'#2',Word2Hex(SegAddr),1,255,255);
  StrRepl(S,'#3',Word2Hex(Ofs(ErrPoint^)),1,255,255);
  StrPCopy(F,S);  SetDlgItemText(HWindow,dl_RuntimeErrText,F);
  if LoadString(HInstance,RuntimeErr+ErrNum,F,255)>0 then
    SetDlgItemText(HWindow,dl_RuntimeErrDesc,F);
end;                 { TRuntimeErrDlg.SetupWindow }

procedure TRuntimeErrDlg.ok(var Msg: TMessage);
label
  Err;
var
  i,j: integer;
begin
  GetDlgItemText(HWindow,dl_RuntimeErrorFile,F,255);
  LFNNew(fl,true); LFNAssign(fl,StrPas(F));
  {$I-}
  if LFNRewrite(fl,0)<>0 then goto Err;
  GetDlgItemText(HWindow,dl_RuntimeErrText,F,255);
  writeln(fl,StrPas(F)); if IoResult<>0 then goto Err;
  GetDlgItemText(HWindow,dl_RuntimeErrDesc,F,255);
  writeln(fl,StrPas(F)); if IoResult<>0 then goto Err;
  writeln(fl); if IoResult<>0 then goto Err;
  if LoadString(HInstance,RuntimeErr_Last,F,255)>0 then
  begin
    S:=StrPas(F);
    for i:=1 to ChrQty(S,#9)+1 do
    begin
      j:=Pos(#9,S);
      if j=0 then writeln(fl,S)
      else begin
        writeln(fl,Copy(S,1,j-1)); Delete(S,1,j);
      end;
      if IoResult<>0 then goto Err;
    end;
  end;
Err:
  {$I+}
  LFNDispose(fl);
  EndDlg(id_ok);
end;       { TRuntimeErrDlg.ok }

procedure UExitProc; far;
begin
  ExitProc:=OldExitProc;
  DisposeEntry(Entry);
  if ExitCode<>0 then    { Runtime error }
  begin
    if ExitCode<>255 then  { not a Halt(255), which needs no response }
      Application^.ExecDialog(New(PRuntimeErrDlg,init(ExitCode,ErrorAddr)));
    ErrorAddr:=Nil;   { Disable the default message }
  end;
end;
{$F-}

{$ELSE}
procedure UExitProc; far;
Var
  icode: Byte;
begin
  ExitProc := OldExitProc;
  CloseFile(bib);
  {$I-}
  ChDir(StartupDir); if Ioresult<>0 then;
  {$I+}
  SetCBreak(ExtendCBreak);  { ^C and ^Break trapping }
  if not ScreenInitialized then
  begin
    CursorOn; exit;
  end;
  restore_mode;
  CursorOn;
  Window(1,1,OldNumColls,OldNumRows);
  if KeepStack^[1].Mode=DontKeep then GotoXY(1,1)
  else begin
    RecallBufferStack(Videobuf^,1);
    if OldYcursor=1 then GotoXY(OldXcursor,OldYcursor)
    else GotoXY(OldXcursor,OldYcursor-1);
  end;
  if ExitCode=0 then
  begin
    writeln;
    if ReportMemory then
      writeln('Min free memory is ',MaxMemmAvail,' bytes, ',MaxMaxmAvail,
              ' bytes in largest block.');
  end;
end;                         { UExitProc }
{$ENDIF}

begin
  OldExitProc := ExitProc;
  ExitProc := @UExitProc;
{$IFDEF WINDOWS}
  WinYieldCounter:=0;
{$ELSE}
  GetCBreak(ExtendCBreak);
  SetCBreak(false);          { ^C and ^Break trapping }
  Open_Files_Called:=false;
  CutPasteBuffer:=Nil;
  StartupDir:=LFNFexpand('');
{$ENDIF}
  MaxMaxmAvail:=MaxAvail; MaxMemmAvail:=MemAvail;
end.
