.\" ====================================================================
.\"  @Troff-man-file{
.\"     author          = "Nelson H. F. Beebe and Geoffrey Tobin",
.\"     version         = "0.6.0",
.\"     date            = "08 March 1995",
.\"     time            = "19:52:00 GMT +11",
.\"     filename        = "dv2dt.man",
.\"     address         = "Center for Scientific Computing
.\"                        Department of Mathematics
.\"                        University of Utah
.\"                        Salt Lake City, UT 84112
.\"                        USA",
.\"     telephone       = "+1 801 581 5254",
.\"     FAX             = "+1 801 581 4148",
.\"     checksum        = "32328 715 2191 12898",
.\"     email           = "beebe@math.utah.edu (Internet)",
.\"     codetable       = "ISO/ASCII",
.\"     keywords        = "DVI, TeX",
.\"     supported       = "no",
.\"     docstring       = "This file contains the UNIX manual pages
.\"                        for the dv2dt utility, a program for
.\"                        converting a binary TeX DVI file to an
.\"                        editable text representation in DTL (DVI Text
.\"                        Language).  The companion dt2dv utility can
.\"                        convert the output DTL file back to a binary
.\"                        DVI file.
.\"
.\"                        The checksum field above contains a CRC-16
.\"                        checksum as the first value, followed by the
.\"                        equivalent of the standard UNIX wc (word
.\"                        count) utility output of lines, words, and
.\"                        characters.  This is produced by Robert
.\"                        Solovay's checksum utility.",
.\"  }
.\" ====================================================================
.if t .ds Te T\\h'-0.1667m'\\v'0.20v'E\\v'-0.20v'\\h'-0.125m'X
.if n .ds Te TeX
.if t .ds Xe X\\h'-0.1667m'\\v'0.20v'E\\v'-0.20v'\\h'-0.125m'T
.if n .ds Xe XeT
.TH DV2DT 1 "08 March 1995" "Version 0.6.0"
.\"======================================================================
.SH NAME
dv2dt \- convert a binary TeX DVI file to DTL text representation
.\"======================================================================
.SH SYNOPSIS
.B dv2dt
.I input-DVI-file
.I output-DTL-file
.PP
If the filenames are omitted, then
.I stdin
and
.I stdout
are assumed.
.\"======================================================================
.SH DESCRIPTION
.B dv2dt
converts a binary \*(Te\& DVI file to an editable
text file in DTL
.RI ( "DVI Text Language" )
format.  The companion
.BR dt2dv (1)
utility can convert the DTL file back to a binary
DVI file.
.\"======================================================================
.SH "DVI COMMAND DESCRIPTION"
\*(Te\& DVI files contain a compact binary
description of typeset pages, as a stream of
operation code bytes, each immediately followed by
zero or more parameter bytes.  The format of DVI
files is fully described in Donald E. Knuth,
.IR "\*(Te\&: The Program" ,
Addison-Wesley (1986), ISBN 0-201-13437-3, as well
as in the
.BR dvitype (1)
literate program source code.
.PP
For convenience, we provide a summary of DVI
commands here.  In the following list, operation
code bytes are given as unsigned decimal values,
followed by their symbolic names (not present in
the DVI file), and a short description.  A
designation like
.I b[+n]
means that the operation code byte is followed by
a parameter
.I b
which uses
.I n
bytes, and is signed.  Without the plus sign, the
parameter is unsigned.  Signed integer parameter
values are always represented in two's complement
arithmetic, which is the system followed by most
computers manufactured today, including all
personal computers and workstations.
.if n .TP \w'\fI128_set1__c[1]\fP'u+3n
.if t .TP \w'\fI243_fnt_def1__k[1]_c[4]_s[4]_d[4]_a[1]_l[1]_n[a+l]\fP'u+3n
.I "0 set_char_0"
Set character 0 from current font.
.TP
.I .\|.\|.
.TP
.I "127 set_char_127"
Set character 127 from current font.
.TP
.I "128 set1  c[1]"
Set 1-byte unsigned character (uchar) number
.IR c .
.TP
.I "129 set2  c[2]"
Set 2-byte uchar number
.IR c .
.TP
.I "130 set3  c[3]"
Set 3-byte uchar number
.IR c .
.TP
.I "131 set4  c[+4]"
Set 4-byte signed character (schar) number
.IR c .
.TP
.I "132 set_rule  a[+4]  b[+4]"
Set rule, height
.IR a ,
width
.IR b .
.TP
.I "133 put1  c[1]"
Put 1-byte uchar
.IR c .
.TP
.I "134 put2  c[2]"
Put 2-byte uchar
.IR c .
.TP
.I "135 put3  c[3]"
Put 3-byte uchar
.IR c .
.TP
.I "136 put4  c[+4]"
Put 4-byte schar
.IR c .
.TP
.I "137 put_rule  a[+4]  b[+4]"
Put rule, height
.IR a ,
width
.IR b .
.TP
.I "138 nop"
Do nothing.
.TP
.I "139 bop  c0[+4]  .\|.\|.  c9[+4]  p[+4]"
Beginning of page.  The parameters
.I "c0  .\|.\|.  c9"
are the \*(Te\& page counters, the contents of
\*(Te\& count registers
.IR "\ecount0  .\|.\|.  \ecount9" .
The parameter
.I p
is the byte offset from the beginning of the DVI
file of the previous
.I bop
operation code byte.  The first such command in
the file has
.IR "p = \-1" .
.TP
.I "140 eop"
End of page.
.TP
.I "141 push"
Push
.RI ( h,v,w,x,y,z )
onto stack.
.TP
.I "142 pop"
Pop
.RI ( h,v,w,x,y,z )
from stack.
.TP
.I "143 right1  b[+1]"
Move right
.I b
units.
.TP
.I "144 right2  b[+2]"
Move right
.I b
units.
.TP
.I "145 right3  b[+3]"
Move right
.I b
units.
.TP
.I "146 right4  b[+4]"
Move right
.I b
units.
.TP
.I "147 w0"
Move right
.I w
units.
.TP
.I "148 w1  b[+1]"
Move right
.I b
units, and set
.IR "w = b" .
.TP
.I "149 w2  b[+2]"
Move right
.I b
units, and set
.IR "w = b" .
.TP
.I "150 w3  b[+3]"
Move right
.I b
units, and set
.IR "w = b" .
.TP
.I "151 w4  b[+4]"
Move right
.I b
units, and set
.IR "w = b" .
.TP
.I "152 x0"
Move right
.I x
units.
.TP
.I "153 x1  b[+1]"
Move right
.I b
units, and set
.IR "x = b" .
.TP
.I "154 x2  b[+2]"
Move right
.I b
units, and set
.IR "x = b" .
.TP
.I "155 x3  b[+3]"
Move right
.I b
units, and set
.IR "x = b" .
.TP
.I "156 x4  b[+4]"
Move right
.I b
units, and set
.IR "x = b" .
.TP
.I "157 down1  a[+1]"
Move down
.I a
units.
.TP
.I "158 down2  a[+2]"
Move down
.I a
units.
.TP
.I "159 down3  a[+3]"
Move down
.I a
units.
.TP
.I "160 down4  a[+4]"
Move down
.I a
units.
.TP
.I "161 y0"
Move right
.I y
units.
.TP
.I "162 y1  a[+1]"
Move right
.I a
units, and set
.IR "y = a" .
.TP
.I "163 y2  a[+2]"
Move right
.I a
units, and set
.IR "y = a" .
.TP
.I "164 y3  a[+3]"
Move right
.I a
units, and set
.IR "y = a" .
.TP
.I "165 y4  a[+4]"
Move right
.I a
units, and set
.IR "y = a" .
.TP
.I "166 z0"
Move right
.I z
units.
.TP
.I "167 z1  a[+1]"
Move right
.I a
units, and set
.IR "z = a" .
.TP
.I "168 z2  a[+2]"
Move right
.I a
units, and set
.IR "z = a" .
.TP
.I "169 z3  a[+3]"
Move right
.I a
units, and set
.IR "z = a" .
.TP
.I "170 z4  a[+4]"
Move right
.I a
units, and set
.IR "z = a" .
.TP
.I "171 fnt_num_0"
Set current font number
.IR "(f) = 0" .
.TP
.I .\|.\|.
.TP
.I "234 fnt_num_63"
Set
.IR "f = 63" .
.TP
.I "235 fnt1  k[1]"
Set
.IR "f = k" .
.TP
.I "236 fnt2  k[2]"
Set
.IR "f = k" .
.TP
.I "237 fnt3  k[3]"
Set
.IR "f = k" .
.TP
.I "238 fnt4  k[+4]"
Set
.IR "f = k" .
.TP
.I "239 xxx1  k[1]  x[k]"
Special string
.I x
with
.I k
bytes.
.TP
.I "240 xxx2  k[2]  x[k]"
Special string
.I x
with
.I k
bytes.
.TP
.I "241 xxx3  k[3]  x[k]"
Special string
.I x
with
.I k
bytes.
.TP
.I "242 xxx4  k[4]  x[k]"
Special string
.I x
with (unsigned)
.I k
bytes.
.TP
.I "243 fnt_def1  k[1] c[4] s[4] d[4] a[1] l[1] n[a+l]"
Define font
.IR k .
The parameters are:
.RS
.TP \w'\fIm\fP'u+3n
.I c
Checksum for TFM file.
.TP
.I s
Scale factor, in DVI units.
.TP
.I d
Design size, in DVI units.
.TP
.I a
Length of the ``area'' or directory.
.TP
.I l
Length of the font name.
.TP
.I n
Area and font name string(s).
.RE
.TP
.I "244 fnt_def2  k[2] c[4] s[4] d[4] a[1] l[1] n[a+l]"
Define font
.IR k .
.TP
.I "245 fnt_def3  k[3] c[4] s[4] d[4] a[1] l[1] n[a+l]"
Define font
.IR k .
.TP
.I "246 fnt_def4  k[+4] c[4] s[4] d[4] a[1] l[1] n[a+l]"
Define font
.IR k .
.TP
.I "247 pre  i[1]  num[4]  den[4]  mag[4]  k[1]  x[k]"
Begin preamble.  The parameters are:
.RS
.TP \w'\fInum\fP'u+3n
.I i
DVI format.  Standard \*(Te\& has
.IR "ID = 2" ,
and \*(Te\&-\*(Xe\& has
.IR "ID = 3" .
.TP
.I num
Numerator of 100 nm / DVI unit.
.TP
.I den
Denominator of 100 nm / DVI unit.
.TP
.I mag
1000 * magnification.
.TP
.I k
Comment length.
.TP
.I x
Comment string.
.RE
.TP
.I "248 post  p[4] num[4] den[4] mag[4] l[4] u[4] s[2] t[2]"
Begin postamble.  The parameters are:
.RS
.TP \w'\fInum\fP'u+3n
.I p
Pointer to final bop.
.TP
.I "num, den, mag"
Duplicates of values in preamble.
.TP
.I l
Height-plus-depth of tallest page, in DVI units.
.TP
.I u
Width of widest page, in DVI units.
.TP
.I s
Maximum stack depth needed to process this DVI file.
.TP
.I t
Total number of pages
.RI ( bop
commands) present.
.RE
.TP
.I "249 post_post  q[4] i[1] 223 .\|.\|. 223"
End postamble.  The parameters are:
.RS
.TP \w'\fI223\fP'u+3n
.I q
Byte offset from the beginning of the DVI file to
the
.I post
command that started the postamble.
.TP
.I i
DVI format ID, as in the preamble.
.TP
.I
223
At least four
.I 223
bytes.
.RE
.TP
.I "250"
Undefined.
.TP
.I .\|.\|.
.TP
.I "255"
Undefined.
.\"======================================================================
.SH "DTL COMMAND DESCRIPTION"
A DTL file contains one line per command, with a
limit of 1024 characters per line.  Each command
contains a symbolic operation name, followed by
zero or more parameter values.  The parameter
value descriptions are not repeated here; they can
be found in the previous section.
.TP \w'\fIw0,_w1,_w2,_w3,_w4\fP'u+3n
variety <variety-name>
This command specifies the name of the DTL file
type; it has no DVI file equivalent.
.TP
.I (text)
Series of set_char commands, for printable ASCII text.
.TP
.I \e(
Literal ASCII left parenthesis in (text).
.TP
.I \e)
Literal ASCII right parenthesis in (text).
.TP
.I \e\e
Literal ASCII backslash in (text).
.TP
.I \e"
Literal ASCII double quote in (text).
.TP
.I \eXY
Set_char for character with hexadecimal code XY,
not in parentheses, but by itself for readability.
.TP
.I "s1, s2, s2, s3"
Set, with (1,2,3,4)-byte charcodes.
.TP
.I sr
.IR set_rule .
.TP
.I "p1, p2, p2, p3"
Put, with (1,2,3,4)-byte charcodes.
.TP
.I pr
.IR put_rule .
.TP
.I nop
.I nop
(do nothing).
.TP
.I bop
.I bop
(beginning of page).
.TP
.I eop
.I eop
(end of page).
.TP
.I [
Push.
.TP
.I ]
Pop.
.TP
.I "r1, r2, r3, r4"
Right, with (1,2,3,4)-byte argument.
.TP
.I "w0, w1, w2, w3, w4"
As in DVI.
.TP
.I "x0, x1, x2, x3, x4"
As in DVI.
.TP
.I "d1, d2, d3, d4"
Down, with (1,2,3,4)-byte argument.
.TP
.I "y0, y1, y2, y3, y4"
As in DVI.
.TP
.I "z0, z1, z2, z3, z4"
As in DVI.
.TP
.I fn
.I fnt_num
(set current font to font number in 0 to 63).
.TP
.I "f1, f2, f3, f4"
.I fnt
(set current font to (1,2,3,4)-byte font number).
.TP
.I special
.I xxx
(special commands with (1,2,3,4)-byte string length).
.TP
.I fd
.I fnt_def
(assign a number to a named font).
.TP
.I pre
Preamble.
.TP
.I post
.I post
(begin postamble).
.TP
.I post_post
.I post_post
(end postamble).
.TP
.I opcode
Undefined DVI command (250 to 255).
.\"======================================================================
.SH "SAMPLE DTL FILE"
The following 2-line \*(Te\& file
.RS
.nf
Hello.
\ebye
.fi
.RE
when processed with the commands
.RS
.nf
tex hello.tex
dv2dt hello.dvi hello.dtl
.fi
.RE
produces this DTL file:
.RS
.nf
variety sequences-6
pre 2 25400000 473628672 1000 27 ' TeX output 1995.03.02:2334'
bop 1 0 0 0 0 0 0 0 0 0 -1
[
d3 -917504
]
d4 42152922
[
d4 -41497562
[
r3 1310720
fd1 0 11374260171 655360 655360 0 5 '' 'cmr10'
fn0
(Hello.)
]
]
d3 1572864
[
r4 15229091
(1)
]
eop
post 42 25400000 473628672 1000 43725786 30785863 2 1
fd1 0 11374260171 655360 655360 0 5 'cmr10'
post_post 152 2 223 223 223 223
.fi
.RE
The command
.RS
.nf
dt2dv hello.dtl hello.dvi
.fi
.RE
will reconstruct the original DVI file.
.\"======================================================================
.SH "SEE ALSO"
.BR dt2dv (1),
.BR dvitype (1),
.BR tex (1).
.\"======================================================================
.SH FILES
.TP \w'\fI*.dvi\fP'u+3n
.I *.dvi
binary \*(Te\& DVI file.
.TP
.I *.dtl
text representation of a \*(Te\& DVI file in
.I "DVI Text Language"
format.
.\"======================================================================
.SH AUTHOR
.B dv2dt
and
.BR dt2dv (1)
were written by
.RS
.nf
Geoffrey Tobin
Department of Electronic Engineering
La Trobe University
Bundoora, Victoria 3083
Australia
Tel: +61 3 479 3736
FAX: +61 3 479 3025
Email: <G.Tobin@ee.latrobe.edu.au>
.fi
.RE
.PP
These manual pages were primarily written by
.RS
.nf
Nelson H. F. Beebe, Ph.D.
Center for Scientific Computing
Department of Mathematics
University of Utah
Salt Lake City, UT 84112
Tel: +1 801 581 5254
FAX: +1 801 581 4148
Email: <beebe@math.utah.edu>
.fi
.RE
.\"==============================[The End]==============================
